import { Plugin } from "..";
import postcss from "postcss";

export default class PostCSS extends Plugin {
  build: undefined;

  name = "postcss";
  rewriteTriggers = ["css"];
  renameTo = "css";
  longLasting = false;
  plugins: postcss.AcceptedPlugin[] = [];

  constructor(plugins: postcss.AcceptedPlugin[]) {
    super();
    this.plugins = plugins;
  }

  async rewriteFile(file: string) {
    const data = await postcss(this.plugins).process(file, {from: undefined});
    return data.css;
  }
}
